﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Text;

namespace VIRP.CRS.BO
{
    [Serializable, DataContract]
    public partial class LabScreening
    {
        #region Fields

        private string gENDER;
        private DateTime dATEOFBIRTH;
        private int aGE;
        private string rACE;
        private string eGFR;

        private string cHEMLABCHEMABNORMAL;
        private DateTime? cHEMLABCHEMLABCHEMCOMPLETEDATETIME;
        private string cHEMLABCHEMLABCHEMRESULTVALUE;
        private DateTime? cHEMLABCHEMLABCHEMSPECIMENDATETIME;
        private string cHEMLABCHEMREFHIGH;
        private string cHEMLABCHEMREFLOW;

        private string sTDLOINCCodeComponent;
        private string sTDLOINCCodeLOINC;
        private string sTDLOINCCodeMethodType;
        private string sTDLOINCCodeProperty;
        private string sTDLOINCCodeUnits;

        #endregion

        #region Constructors

        public LabScreening()
        {
        }

        #endregion

        #region Properties

        [DataMember]
        public string Gender
        {
            get { return this.gENDER; }
            set { this.gENDER = value; }
        }

        [DataMember]
        public DateTime DateOfBirth
        {
            get { return this.dATEOFBIRTH; }
            set { this.dATEOFBIRTH = value; }
        }

        [DataMember]
        public int Age
        {
            get
            {
                return this.aGE;
            }
            set
            {
                this.aGE = value;
                this.CalculateEGFR();
            }
        }

        [DataMember]
        public string Race
        {
            get { return this.rACE; }
            set { this.rACE = value; }
        }

        [DataMember]
        public string EGFR
        {
            get { return this.eGFR; }
            set { this.eGFR = value; }
        }

        [DataMember]
        public string ABNORMAL
        {
            get { return this.cHEMLABCHEMABNORMAL; }
            set { this.cHEMLABCHEMABNORMAL = value; }
        }

        [DataMember]
        public DateTime? LABCHEMCOMPLETEDATETIME
        {
            get { return this.cHEMLABCHEMLABCHEMCOMPLETEDATETIME; }
            set { this.cHEMLABCHEMLABCHEMCOMPLETEDATETIME = value; }
        }

        [DataMember]
        public string LABCHEMRESULTVALUE
        {
            get
            {
                return this.cHEMLABCHEMLABCHEMRESULTVALUE;
            }
            set
            {
                this.cHEMLABCHEMLABCHEMRESULTVALUE = value;
                this.CalculateEGFR();
            }
        }

        [DataMember]
        public DateTime? LABCHEMSPECIMENDATETIME
        {
            get { return this.cHEMLABCHEMLABCHEMSPECIMENDATETIME; }
            set { this.cHEMLABCHEMLABCHEMSPECIMENDATETIME = value; }
        }

        [DataMember]
        public string REFHIGH
        {
            get { return this.cHEMLABCHEMREFHIGH; }
            set { this.cHEMLABCHEMREFHIGH = value; }
        }

        [DataMember]
        public string REFLOW
        {
            get { return this.cHEMLABCHEMREFLOW; }
            set { this.cHEMLABCHEMREFLOW = value; }
        }

        [DataMember]
        public string Component
        {
            get { return this.sTDLOINCCodeComponent; }
            set { this.sTDLOINCCodeComponent = value; }
        }

        [DataMember]
        public string LOINC
        {
            get { return this.sTDLOINCCodeLOINC; }
            set { this.sTDLOINCCodeLOINC = value; }
        }

        [DataMember]
        public string MethodType
        {
            get { return this.sTDLOINCCodeMethodType; }
            set { this.sTDLOINCCodeMethodType = value; }
        }

        [DataMember]
        public string Property
        {
            get { return this.sTDLOINCCodeProperty; }
            set { this.sTDLOINCCodeProperty = value; }
        }

        [DataMember]
        public string Units
        {
            get { return this.sTDLOINCCodeUnits; }
            set { this.sTDLOINCCodeUnits = value; }
        }

        #endregion

        #region Methods

        private void CalculateEGFR()
        {
            double tempEGFR = 0.0;
            double labResultValue = 0.0;

            if (!string.IsNullOrEmpty(this.cHEMLABCHEMLABCHEMRESULTVALUE))
                double.TryParse(this.cHEMLABCHEMLABCHEMRESULTVALUE, out labResultValue);

            if (labResultValue > 0 && this.aGE > 0)
                tempEGFR = 175 * (Math.Pow(labResultValue, -1.154)) * (Math.Pow(this.aGE, -.203));

            if (this.rACE == "BLACK OR AFRICAN AMERICAN")
                tempEGFR *= 1.212;

            if (this.gENDER == "F")
                tempEGFR *= .742;

            this.eGFR = tempEGFR.ToString("N1");

            //FormatNumber((175 * (Fields!LABCHEMRESULTVALUE.Value ^ -1.154) * (Fields!Age.Value ^ -.203) *
            //IIf(Fields!Race.Value = "BLACK OR AFRICAN AMERICAN", 1.212, 1) * IIf(Fields!Gender.Value = "F", .742, 1)), 1)
        }

        #endregion
    }
}
